<?php
/*--------------------------------------------------------------------------------------------------
    ServiceProvider.php 2020-02-17
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2020 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Shop\Attributes\SellingUnitImages\Database;

use Doctrine\DBAL\Connection;
use Gambio\Core\Event\EventListenerProvider;
use Gambio\Shop\SellingUnit\Database\Configurations\ShopPaths;
use Gambio\Shop\SellingUnit\Database\Image\Events\OnImageCollectionCreateEvent;
use Gambio\Shop\SellingUnit\Database\Image\Events\OnImageCollectionCreateEventInterface;
use Gambio\Shop\Product\SellingUnitImage\Database\Repository\Factories\ImageFactory;
use Gambio\Shop\Product\SellingUnitImage\Database\Repository\Factories\ImageFactoryInterface;
use Gambio\Shop\Attributes\SellingUnitImages\Database\Interfaces\ReaderDatabaseInterface;
use Gambio\Shop\Attributes\SellingUnitImages\Database\Interfaces\ReadRepositoryInterface;
use Gambio\Shop\Attributes\SellingUnitImages\Database\Interfaces\ReadServiceInterface;
use Gambio\Shop\Attributes\SellingUnitImages\Database\Listener\OnImageCollectionCreateEventListener;

use Gambio\Shop\Attributes\SellingUnitImages\Database\Repositories\ReaderDatabase;
use Gambio\Shop\Attributes\SellingUnitImages\Database\Repositories\ReadRepository;
use League\Container\ServiceProvider\AbstractServiceProvider;
use League\Container\ServiceProvider\BootableServiceProviderInterface;
use Throwable;

class ServiceProvider  extends AbstractServiceProvider implements BootableServiceProviderInterface
{
    /**
     * @var array
     */
    protected $provides = [
        OnImageCollectionCreateEventListener::class
    ];
    
    
    /**
     * @inheritDoc
     */
    public function register()
    {
        $this->container->share(OnImageCollectionCreateEventListener::class)->addArgument(ReadServiceInterface::class);
    
        $this->container->share(ReadServiceInterface::class, ReadService::class)->addArgument(
            ReadRepositoryInterface::class
        );
    
        $this->container->share(ReadRepositoryInterface::class, ReadRepository::class)->addArgument(
            ReaderDatabaseInterface::class
        )->addArgument(ImageFactoryInterface::class);
    
        $this->container->share(ReaderDatabaseInterface::class, ReaderDatabase::class)->addArgument(
            Connection::class
        );
    
        $this->container->share(ImageFactoryInterface::class, ImageFactory::class)->addArgument(ShopPaths::class);
        
        $pathBase = '';
        $webBase  = '';
        
        try {
            $pathBase = $this->container->get('path.base');
            $webBase  = $this->container->get('web.base');
        } catch (Throwable $e) {
            /**
             * TODO: This try/catch mus be removed as soon the literals are exported
             */
        }
        
        $this->container->share(ShopPaths::class)->addArgument($pathBase)->addArgument($webBase);
    }
    
    
    /**
     * @inheritDoc
     */
    public function boot()
    {
        /** @var EventListenerProvider $listenerProvider */
        $listenerProvider = $this->container->get(EventListenerProvider::class);
        $listenerProvider->attachListener(
            OnImageCollectionCreateEvent::class,
            OnImageCollectionCreateEventListener::class
        );
    }
    
    
}